<?php

namespace App\Http\Resources\API;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class PodcastsResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $tags = $this->relationLoaded('tags') ? $this->whenLoaded('tags'):null;
        $therapist_community = $this->relationLoaded('therapist_community') ? $this->whenLoaded('therapist_community'):null;
        $therapist = $this->relationLoaded('therapist') ? $this->whenLoaded('therapist'):null;
        return [
                "id" =>  $this->id,
                'therapist_id' => $this->therapist_id,
                'therapist_name' => $therapist ? $therapist->name :"",
                'therapist_community_id' => $this->therapist_community_id,
                'therapist_community_name' => $therapist_community ? $therapist_community->name :"",
                "tag_ids" => $tags ? TagsResource::collection($this->whenLoaded('tags',function(){
                    return $this->tags;
                }))->pluck('id')->toArray():[],
                "tags" => $tags ? TagsResource::collection($tags):[],
                "name" =>  $this->name,
                "description" =>  $this->description,
                "slug" =>  $this->slug,
                "is_active" =>  $this->is_active,
                "is_featured" =>  $this->is_featured,
                "icon" =>  $this->icon,
                "image" =>  $this->image,
                "audio" =>  $this->audio,
                "video" =>  $this->video,
                "link_type" =>  $this->link_type,
                "file_type" =>  $this->file_type,
                "file_url" =>  $this->file_url,
                "created_at" =>  Carbon::parse($this->created_at)->format('Y-m-d'),
                "updated_at" =>  $this->updated_at,
        ];
    }
}
